import '../../domain/entities/staking_position_entity.dart';

class StakingPositionModel {
  final String id;
  final String poolId;
  final String status;
  final DateTime createdAt;
  final DateTime? endDate;
  final double amount;
  final double earningsTotal;
  final double earningsUnclaimed;
  final int? timeRemaining;

  StakingPositionModel({
    required this.id,
    required this.poolId,
    required this.status,
    required this.createdAt,
    this.endDate,
    required this.amount,
    required this.earningsTotal,
    required this.earningsUnclaimed,
    this.timeRemaining,
  });

  factory StakingPositionModel.fromJson(Map<String, dynamic> json) {
    final earnings = json['earnings'] as Map<String, dynamic>? ?? {};
    return StakingPositionModel(
      id: json['id'] as String,
      poolId: json['poolId'] as String,
      status: json['status'] as String,
      createdAt: DateTime.parse(json['createdAt'] as String),
      endDate: json['endDate'] != null
          ? DateTime.parse(json['endDate'] as String)
          : null,
      amount: (json['amount'] as num).toDouble(),
      earningsTotal: (earnings['total'] as num?)?.toDouble() ?? 0.0,
      earningsUnclaimed: (earnings['unclaimed'] as num?)?.toDouble() ?? 0.0,
      timeRemaining: json['timeRemaining'] as int?,
    );
  }

  StakingPositionEntity toEntity() => StakingPositionEntity(
        id: id,
        poolId: poolId,
        status: status,
        createdAt: createdAt,
        endDate: endDate,
        amount: amount,
        earningsTotal: earningsTotal,
        earningsUnclaimed: earningsUnclaimed,
        timeRemaining: timeRemaining,
      );
}
